unit Unit1;

//      FindFirst, FindNext
//  FindClose        .
// : ( *.* ) -  ,  ( *.pas ) -    
// ( pas ).

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    StringGrid1: TStringGrid;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowDir(RqDirFiles : string);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ShowDir(RqDirFiles : string);
const
  TitArr : array [0..3] of string = ( '',' ','','');
var
  sr         : TSearchRec;
  FileAttrs  : word;
  Ind        : integer;
  StrAttr    : string;
begin
  StringGrid1.RowCount := 1;
  if CheckBox1.Checked
  then FileAttrs := faReadOnly
  else FileAttrs := 0;
  if CheckBox2.Checked then FileAttrs := FileAttrs or faHidden;
  if CheckBox3.Checked then FileAttrs := FileAttrs or faSysFile;
  if CheckBox4.Checked then FileAttrs := FileAttrs or faVolumeID;
  if CheckBox5.Checked then FileAttrs := FileAttrs or faDirectory;
  if CheckBox6.Checked then FileAttrs := FileAttrs or faArchive;
  if CheckBox7.Checked then FileAttrs := FileAttrs or faAnyFile;

  with StringGrid1 do
  begin
    RowCount := 1;
    //Ind := RowCount - 1;
    if FindFirst(RqDirFiles, FileAttrs, sr) = 0 then
    begin
      repeat
        sr.Attr := sr.Attr and $ff;
        if ((sr.Attr and FileAttrs) = sr.Attr) and (sr.Name <> '')
        then begin
          Ind := RowCount;
          RowCount := RowCount + 1;
          Cells[0,Ind] := IntToStr(Ind);
          Cells[1,Ind] := sr.Name;
          Cells[3,Ind] := IntToStr(sr.Size);
          StrAttr := '';
          if (sr.Attr and faSymLink)   > 0 then StrAttr := '[SLINK] ';
          if (sr.Attr and faDirectory) > 0 then StrAttr := '[DIR] ';
          if (sr.Attr and faVolumeID)  > 0 then StrAttr := StrAttr + '[VolId] ';
          if (sr.Attr and faSysFile)   > 0 then StrAttr := StrAttr + 'S';
          if (sr.Attr and faHidden)    > 0 then StrAttr := StrAttr + 'H';
          if (sr.Attr and faReadOnly)  > 0 then StrAttr := StrAttr + 'R';
          if (sr.Attr and faArchive)   > 0 then StrAttr := StrAttr + 'A';
          Cells[2,Ind] := StrAttr;
        end;
      until FindNext(sr) <> 0;
      FindClose(sr);
    end;
    if RowCount < 2
    then begin
       RowCount := 2;
       for Ind := 0 to ColCount - 1 do Cells[Ind, 1] := '';
    end;
    FixedRows := 1;
    for Ind := 0 to ColCount - 1 do Cells[Ind, 0] := TitArr[Ind];
  end; // of with StringGrid1
end;

procedure TForm1.CheckBoxClick(Sender: TObject);
begin
  ShowDir(Edit1.Text);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShowDir(Edit1.Text);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Edit1.Text := GetCurrentDir + '\*.*';
  ShowDir(Edit1.Text);
end;



end.
